package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.statistic.AbcBillStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.AbcBillStatisticSearchParam;
import java.util.List;

/**
 * 农总行账单数据表-对账用
 * @author kjj mybatis generator 
 * @date 2024-11-04
 */
@AdvancedFeignClient
public interface RemoteAbcBillStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 农总行账单数据-对账用集合
     */
    List<AbcBillStatisticDto> selectPage(AbcBillStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AbcBillStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 农总行账单数据-对账用
     */
    AbcBillStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 农总行账单数据-对账用
     * @return 执行结果
     */
    int insert(AbcBillStatisticDto dto);

    /**
     * 更新
     * @param dto 农总行账单数据-对账用
     * @return 影响行数
     */
    int update(AbcBillStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据商品ID 批量查询数据 量大不可用
     * @param specId
     * @return
     */
    List<AbcBillStatisticDto> selectBySpecId(String specId);
}