package cn.com.duiba.quanyi.center.api.dto.coupon;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 美团支付券活动关联表
 * @author mybatis generator 
 * @date 2024-09-12
 */
@Data
public class MeiTuanCouponActivityDto implements Serializable {
     
    private static final long serialVersionUID = 17261246663392534L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 美团支付券主键,tb_meituan_coupon.id
     */
    private Long meituanCouponId;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 活动类型：1=白名单领奖、2=兑吧卡密包
     */
    private Integer activityType;

    /**
     * 发放开始时间
     */
    private Date grantStartTime;

    /**
     * 发放结束时间
     */
    private Date grantEndTime;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;
}