package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.DouYinCouponActivityDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 抖音支付券和活动关联
 */
@AdvancedFeignClient
public interface RemoteDouYinCouponActivityService {

    /**
     * 批量新增
     *
     * @param list 抖音支付券活动关联
     * @return 执行结果
     */
    int batchInsert(List<DouYinCouponActivityDto> list);

    /**
     * 批量更新
     *
     * @param list 抖音支付券活动关联
     * @return 执行结果
     */
    int batchUpdate(List<DouYinCouponActivityDto> list);

    /**
     * 批量逻辑删除
     *
     * @param ids 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    Integer countByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeId
     * @return
     */
    List<DouYinCouponActivityDto> selectByActivityPrizeIdAndActivityType(Long activityPrizeId, Integer activityType);

    /**
     * 根据活动奖项查询批次列表
     *
     * @param activityPrizeIds
     * @return
     */
    List<DouYinCouponActivityDto> selectByActivityPrizeIds(List<Long> activityPrizeIds, Integer activityType);

    /**
     * 根据立减金ID批量查询
     *
     * @param douyinCouponIds 抖音支付券ID集合
     * @return 抖音支付券活动关联列表
     */
    List<DouYinCouponActivityDto> selectByDouYinCouponIds(Set<Long> douyinCouponIds);

    /**
     * 批量查询批次关联活动数量
     * @param couponIds 批次ID列表
     * @return key：批次ID，value：关联活动数量
     */
    Map<Long, Integer> selectActivityCountMapByCouponIds(Set<Long> couponIds);

    /**
     * 根据支付券ID查询最近一条关联关系（不包含已删除的）
     *
     * @param douyinCouponId 抖音支付券ID
     * @return 抖音支付券活动关联
     */
    DouYinCouponActivityDto selectByDouYinCouponId(Long douyinCouponId);
}
