package cn.com.duiba.quanyi.center.api.param.settlement.holo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/11/26 16:26
 */
@Data
public class SettlementHoloCreateParam implements Serializable {
    
    private static final long serialVersionUID = 8716875783192392242L;

    /**
     * 结算单名称
     */
    private String settlementName;

    /**
     * 商品类型：1-非垫资，2-垫资
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementGoodsTypeEnum
     */
    private Integer goodsType;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 对接人ID
     */
    private List<Long> contactsIdList;

    /**
     * 需求ID
     */
    private List<Long> demandIdList;

    /**
     * 结算周期-开始时间
     */
    private Date startDate;

    /**
     * 结算周期-结束时间
     */
    private Date endDate;

    /**
     * 选择的商品批次
     */
    private List<SettlementHoloGoodsSelectParam> selectList;
    
    /**
     * 结算类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementTypeEnum
     */
    private Integer settlementType;

    /**
     * 方案唯一标记（按金额时有值）
     */
    private String key;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 前端传入的应收金额
     */
    private Long receivableAmount;
}
