package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiThirdOrderBindDto;
import cn.com.duiba.quanyi.center.api.param.api.ApiThirdOrderBindSearchParam;
import java.util.List;

/**
 * api供货三方订单绑定表
 * @author kjj mybatis generator 
 * @date 2024-09-04
 */
@AdvancedFeignClient
public interface RemoteApiThirdOrderBindService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return api供货三方订单绑定集合
     */
    List<ApiThirdOrderBindDto> selectPage(ApiThirdOrderBindSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ApiThirdOrderBindSearchParam param);

    /**
     * 根据唯一键查询
     * @return api供货三方订单绑定
     */
    ApiThirdOrderBindDto selectByUk(String thirdOrderNo, String couponNo, Long apiJointId);

    /**
     * 新增
     * @param dto api供货三方订单绑定
     * @return 执行结果
     */
    Long insert(ApiThirdOrderBindDto dto);
}