package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceEquityPolicyDto;

import java.util.List;

/**
 * 保司权益保单表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceEquityPolicyService {

    /**
     * 根据车险保单及车牌号查询权益ID列表
     * @param policyNo 车险保单号
     * @param carNumber 车牌号
     * @param customerPhone 客户手机号
     * @return 去重的权益ID
     */
    List<Long> selectEquityIdByPolicyCarNumber(String policyNo, String carNumber, String customerPhone);

    /**
     * 根据权益ID批量查询车险保单
     * @param equityIds 权益ID列表
     * @return 保司权益保单列表
     */
    List<InsuranceEquityPolicyDto> selectCarPolicyListByEquityIds(List<Long> equityIds);

    /**
     * 根据权益ID批量查询
     * @param equityId 权益ID
     * @return 保司权益保单列表
     */
    List<InsuranceEquityPolicyDto> selectListByEquityId(Long equityId);

    /**
     * 批量查询存在的保险单
     * @param policyNos 保险单号
     * @return 保司权益保单列表
     */
    List<InsuranceEquityPolicyDto> selectExistPolicy(List<String> policyNos);


    /**
     * 根据权益ID批量查询保单
     * @param equityIds 权益ID列表
     * @return 保司权益保单列表
     */
    List<InsuranceEquityPolicyDto> selectPolicyListByEquityIds(List<Long> equityIds);

    /**
     * 注意此方法会查询删除的数据 导出专用
     * @param equityIds 权益ID列表
     * @return 保司权益保单列表
     */
    List<InsuranceEquityPolicyDto> selectAllPolicyListByEquityIds(List<Long> equityIds);



    /**
     * 根据保单及车牌号查询权益ID列表
     * @param policyNo 保单号
     * @param carNumber 车牌号
     * @param customerPhone 客户手机号
     * @return 去重的权益ID
     */
    List<Long> selectEquityIdByPolicyNoCarNumber(String policyNo, String carNumber, String customerPhone);

}