package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 发票
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteInvoiceService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 发票集合
     */
    List<InvoiceDto> selectPage(InvoiceSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InvoiceSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 发票
     */
    InvoiceDto selectById(Long id);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 发票
     */
    List<InvoiceDto> selectByIds(List<Long> ids);

    /**
     * 根据开票主体id查询
     * @param invoiceTitleId 开票主体id
     * @return 发票
     */
    List<InvoiceDto> selectByInvoiceTitleId(Long invoiceTitleId);

    /**
     * 根据开票申请id查询
     * @param invoiceApplyId 开票申请id
     * @return 发票
     */
    List<InvoiceDto> selectByInvoiceApplyId(Long invoiceApplyId);

    /**
     * 根据开票主体id查询
     * @param invoiceTitleIds 开票主体id
     * @param amounts 发票金额
     * @return 发票
     */
    List<InvoiceDto> selectByInvoiceTitleIdsAndAmounts(Set<Long> invoiceTitleIds, Set<Long> amounts);

    /**
     * 新增
     * @param dto 发票
     * @return 执行结果
     */
    int insert(InvoiceDto dto);

    /**
     * 更新
     * @param dto 发票
     * @return 影响行数
     */
    int update(InvoiceDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}