package cn.com.duiba.quanyi.center.api.remoteservice.minsheng;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pay.create.PayCreateOrderResultDto;
import cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum;
import cn.com.duiba.quanyi.center.api.param.minsheng.MinshengPayActivityCreateOrderParam;


/**
 * remote minsheng pay activity service
 *
 * @author wangguanhua
 */
@AdvancedFeignClient
public interface RemoteMinshengPayActivityService {

    /**
     * 创建订单
     *
     * @param param 参数
     * @return 结果
     */
    PayCreateOrderResultDto createOrder(MinshengPayActivityCreateOrderParam param);

    /**
     * 创建订单
     *
     * @param payBizType 业务类型
     * @param param      参数
     * @return 结果
     */
    PayCreateOrderResultDto createOrderByPayBizType(Integer payBizType, MinshengPayActivityCreateOrderParam param);
}
