package cn.com.duiba.quanyi.center.api.remoteservice.holo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bill.BillTaskDto;
import cn.com.duiba.quanyi.center.api.dto.holo.HoloDuibaLiveColumnDto;
import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataHologresDownloadParam;
import cn.com.duiba.quanyi.center.api.param.bill.BillTaskSearchParam;

import java.util.List;


/**
 * Holo
 * @author chenyongkun
 */
@AdvancedFeignClient
public interface RemoteHoloDuibaLiveService {

    /**
     * 查询表列字段信息
     * @param tableName
     * @return
     */
    List<HoloDuibaLiveColumnDto> selectColumnByTableName(String tableName);

    /**
     * 根据schema查询所有表名
     * @param schemaName
     * @param tableName
     * @return
     */
    List<String> selectAllTableBySchema(String schemaName, String tableName);

}