package cn.com.duiba.quanyi.center.api.remoteservice.qy.autogrant;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.autogrant.AutoGrantGoodsOrderTaskDto;

import java.util.Date;
import java.util.List;

/**
 * 自动塞券任务表
 *
 * @author kjj mybatis generator
 * @date 2025-01-22
 */
@AdvancedFeignClient
public interface RemoteAutoGrantGoodsOrderTaskService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 自动塞券任务
     */
    AutoGrantGoodsOrderTaskDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 自动塞券任务
     * @return 执行结果
     */
    int insert(AutoGrantGoodsOrderTaskDto dto);

    /**
     * 更新
     *
     * @param dto 自动塞券任务
     * @return 影响行数
     */
    int update(AutoGrantGoodsOrderTaskDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 生成发放任务记录
     *
     * @param mainOrderNum main order num
     * @return {@link Boolean }
     */
    Boolean psbcGenerateTask(String mainOrderNum);
}