package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.BankEnum;
import cn.com.duiba.quanyi.center.api.enums.coupon.AlipayBankCardTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author nongfu
 * @Date 2024/8/27 10:54
 */
@Data
public class ActivityTemplatePayStandardDto implements Serializable {
    private static final long serialVersionUID = -3872667651068346895L;

    /**
     * 支付卡银行体系
     * @see BankEnum
     */
    private String payBankSystem;
    /**
     * 支付卡类型 1:借记卡 2:信用卡
     * @see AlipayBankCardTypeEnum
     */
    private String payCardType;
    /**
     * 发起支付的时候需要支付的金额
     */
    private Long needPayAmount;
    /**
     * 实际支付金额
     */
    private Integer actualPayAmount;
    /**
     * 确认弹窗辅助文案
     */
    private String desc;
    /**
     * 优惠标记
     */
    private String payTag;

}
