package cn.com.duiba.quanyi.center.api.param.settlement;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 结算单
 * @author mybatis generator 
 * @date 2024-11-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SettlementSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17329512198651050L;

    /**
     * 结算单ID
     */
    private Long id;

    /**
     * 结算单ID集合
     */
    private List<Long> ids;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 实际结算人ID
     */
    private Long settlementContactsId;

    /**
     * 结算单名称(全匹配)
     */
    private String settlementName;

    /**
     * 结算单名称(左匹配)
     */
    private String settlementNameLike;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 结算单状态，为空不校验
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatusEnum
     */
    private List<Integer> settlementStatusList;

    /**
     * 创建时间-开始时间
     */
    private Date gmtCreateStart;

    /**
     * 创建时间-结束时间
     */
    private Date gmtCreateEnd;
}