package cn.com.duiba.quanyi.center.api.remoteservice.contract;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractContactsDto;
import cn.com.duiba.quanyi.center.api.param.ContactsPageQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 合同对接人表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteContractContactsService {
    /**
     * 合同联系人分页查询
     *
     * @param param
     * @return
     */
    List<ContractContactsDto> findContactsPageByParam(ContactsPageQueryParam param);

    /**
     * 合同联系人统计
     *
     * @param param
     * @return
     */
    Integer countContactsByParam(ContactsPageQueryParam param);

    /**
     * 查询合同下联系人列表
     *
     * @param contractId
     * @return
     */
    List<ContractContactsDto> findContactsByContractId(Long contractId);
    /**
     * 根据合同id集合 批量查询合同下联系人
     * @return
     */
    List<ContractContactsDto> findContactsByContractIdList(Set<Long> contractIds);

    /**
     * 根据id查询联系人详情
     *
     * @return
     */
    ContractContactsDto findContactsById(Long contactsId);

    /**
     * 根据id批量查询联系人详情
     * @param ids
     * @return
     */
    List<ContractContactsDto> findByIds(List<Long> ids);

    /**
     * 根据姓名查询联系人
     *
     * @param contractId
     * @param userName
     * @return
     */
    List<ContractContactsDto> findContactsByName(Long contractId, String userName);

    /**
     * 新增联系人
     *
     * @param dto
     * @return
     */
    Long insert(ContractContactsDto dto);

    /**
     * 更新联系人
     *
     * @param dto
     * @return
     */
    int updateContacts(ContractContactsDto dto);

    /**
     * 删除联系人
     *
     * @param contactsId
     */
    int deleteContacts(Long contactsId);
}
