package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author xuzhigang
 * @date 2024/11/30 10:21
 **/
@Getter
@AllArgsConstructor
public enum InvoiceTypeEnum {
    SPECIAL_VAT_INVOICE(1, "增值税专用发票"),

    GENERAL_INVOICE(2, "普票")
    ;

    private final int type;

    private final String desc;

    public static String getDescByType(int type) {
        return Stream.of(values()).filter(item -> item.getType() == type).findFirst().map(InvoiceTypeEnum::getDesc).orElse(null);
    }
}
