package cn.com.duiba.quanyi.center.api.remoteservice.coupon;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.BindDemandGoodsParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponAllocationParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponQueryParam;
import cn.com.duiba.quanyi.center.api.param.coupon.WxCouponSaveOrUpdateParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 微信立减金表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteWxCouponService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 微信立减金
     */
    WxCouponDto selectById(Long id);

    /**
     * 根据批次号查询
     *
     * @param stockId 批次号
     * @return 微信立减金
     */
    WxCouponDto selectByStockId(String stockId);

    /**
     * 根据批次号批量查询
     *
     * @param stockIds 批次号
     * @return 微信立减金
     */
    List<WxCouponDto> selectByStockIds(List<String> stockIds);

    /**
     * 根据主键批量查询
     *
     * @param list 主键
     * @return 微信立减金
     */
    Map<Long, WxCouponDto> selectByIdList(Set<Long> list);

    /**
     * 根据需求ID查询
     *
     * @param demandId 需求ID
     * @return 微信立减金 列表
     */
    List<WxCouponDto> selectByDemandId(Long demandId);
    /**
     * 根据需求ID及skuI及amount查询
     *
     * @param queryParam 查询参数
     * @return 微信立减金 列表
     */
    List<WxCouponDto> selectByDemandSkuIdAndAmount(WxCouponQueryParam queryParam);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandId 需求ID
     * @param skuId    商品skuId
     * @return 微信立减金 列表
     */
    List<WxCouponDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 分页查询
     *
     * @param param 分页参数
     * @return 微信立减金 列表
     */
    List<WxCouponDto> selectPage(WxCouponPageParam param);

    /**
     * 总条数
     *
     * @param param 分页参数
     * @return 总条数
     */
    long selectCount(WxCouponPageParam param);

    /**
     * 新增或修改微信立减金
     *
     * @param param 新增或修改参数
     * @return 是否成功
     */
    Long saveOrUpdate(WxCouponSaveOrUpdateParam param);

    /**
     * 分配
     *
     * @param param 参数
     * @return 是否成功
     */
    boolean allocation(WxCouponAllocationParam param);

    /**
     * 开启或关闭告警
     *
     * @param id       主键
     * @param needWarn 是否需要告警
     * @return 影响行数
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    int openOrCloseWarn(Long id, Integer needWarn);

    /**
     * 逻辑删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
    /**
     * 批次启用停用
     *
     * @param id 主键
     * @return 执行结果
     */
    int updateEnableStatus(Long id,Integer enableStatus);

    /**
     * 绑定到需求商品
     *
     * @return
     */
    int bindDemandGoods(BindDemandGoodsParam param);

    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<BindDemandGoodsParam> list);

    /**
     * 批量解绑需求商品
     *
     * @param ids           主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 解除绑定
     *
     * @return
     */
    int unbindDemandGoods(Long id, Long demandGoodsId);

    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId
     * @return
     */
    List<WxCouponDto> findByDemandGoodsId(Long demandGoodsId);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(WxCouponBatchUpdateCreatorParam param);

    /**
     * 查询创建人数量
     *
     * @param createOperatorId 创建人ID
     * @return 数量
     */
    long selectCreatorCount(Long createOperatorId);

    /**
     * 更新是否自动加款
     *
     * @param id           逐渐id
     * @param autoAddMoney 0-不自动加款 1-自动加款
     * @return 执行结果
     */
    int updateAutoAddMoney(Long id, Integer autoAddMoney);

    /**
     * 更新是否自动加款和预算金额
     *
     * @param id           逐渐id
     * @param autoAddMoney 0-不自动加款 1-自动加款
     * @param budgetAmount 预算金额
     * @return 执行结果
     */
    int updateAutoAddMoneyAndBudgetAmount(Long id, Integer autoAddMoney, Long budgetAmount);

    /**
     * 批量更新
     *
     * @param wxCouponDtoList 立减金集合
     * @return 影响行数
     */
    int batchUpdate(List<WxCouponDto> wxCouponDtoList);

    /**
     * 取消关联
     *
     * @param id 支付宝立减金ID
     * @return 是否成功
     */
    boolean cancelAssociation(Long id);
    /**
     * 批量取消关联
     *
     * @param idList 支付宝立减金ID集合
     * @return 是否成功
     */
    boolean batchCancelAssociation(List<Long> idList);

    /**
     * 更新
     *
     * @param dto 微信立减金
     * @return 执行结果
     */
    int update(WxCouponDto dto);

    /**
     * 更新退款截止日
     * @param couponId 批次主键id
     * @param settlementDeadlineDays 退款截止日
     * @return 影响条数
     */
    int updateSettlementDeadlineDays(Long couponId, Integer settlementDeadlineDays);
}