package cn.com.duiba.quanyi.center.api.param.demand;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 付款记录
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DemandPaymentRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17332135616218988L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 付款申请ID
     */
    private Long paymentInfoId;

    /**
     * 记账日期
     */
    private Date accountingDate;

    /**
     * 付款金额
     */
    private Long paymentAmount;

    /**
     * 付款附件
     */
    private String paymentAttachment;

    /**
     * 付款附件原文件名
     */
    private String paymentAttachmentName;

    /**
     * 备注
     */
    private String recordRemark;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;
}