package cn.com.duiba.quanyi.center.api.remoteservice.demand;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandPurchaseRecordDto;

import java.util.List;

/**
 * 需求采购凭证记录
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteDemandPurchaseRecordService {

    /**
     * 根据需求单id查询需求采购凭证记录
     *
     * @param demandId 需求单id
     * @return 需求采购凭证记录
     */
    List<DemandPurchaseRecordDto> getPurchaseRecordListByDemandId(Long demandId);

    /**
     * 新增
     *
     * @param dto 需求采购凭证记录
     * @return 主键
     */
    Long insert(DemandPurchaseRecordDto dto);
}