package cn.com.duiba.quanyi.center.api.remoteservice.qy.abc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.abc.AbcBillPushDto;
import cn.com.duiba.quanyi.center.api.dto.qy.abc.AbcBillTaskDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.AbcBillTaskSearchParam;
import java.util.List;

/**
 * 农总行任务执行表
 * @author kjj mybatis generator 
 * @date 2024-12-10
 */
@AdvancedFeignClient
public interface RemoteAbcBillTaskService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 农总行任务执行集合
     */
    List<AbcBillTaskDto> selectPage(AbcBillTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AbcBillTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 农总行任务执行
     */
    AbcBillTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 农总行任务执行
     * @return 执行结果
     */
    int insert(AbcBillTaskDto dto);

    /**
     * 更新
     * @param dto 农总行任务执行
     * @return 影响行数
     */
    int update(AbcBillTaskDto dto);
    /**
     * 更新
     * @param dtoList 农总行任务执行
     * @return 影响行数
     */
    int batchUpdate(List<AbcBillTaskDto> dtoList);

    int delete(Long id);

    /**
     * 通过商品ID查询推送总数
     * @param specIds
     * @return
     */
    long selectCountBySpecIds(List<String> specIds);

    /**
     * 根据批次ID去更新状态
     * @param specIds
     * @return
     */
    int updateStatusBySpecIds(List<String> specIds,  Integer batchState);

    /**
     * 通过商品ID批量查询
     * @param specIds
     * @return
     */
    List<AbcBillTaskDto> selectBySpecIds(List<String> specIds);


    /**
     * 执行推送任务
     * @param abcBillPushDtoList
     * @param operatorName
     */
    void executeTask(List<AbcBillPushDto> abcBillPushDtoList, String operatorName);
}