package cn.com.duiba.quanyi.center.api.dto.api.doc.result.sync;

import cn.com.duiba.quanyi.center.api.dto.api.doc.result.ApiDocOrderResultDto;
import cn.com.duiba.quanyi.center.api.enums.api.ApiKmTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * API文档-订单结果-非券包-同步
 * @author lizhi
 * @date 2024/7/17 10:33
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ApiDocSingleSyncOrderResultDto extends ApiDocOrderResultDto {
    
    private static final long serialVersionUID = -7690265335597876894L;

    /**
     * 订单状态：
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 错误码，业务错误码，一般是业务逻辑的错误码
     */
    private String failCode;

    /**
     * 错误描述
     */
    private String failDesc;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 卡密类型
     * @see ApiKmTypeEnum
     */
    private Integer kmType;

    /**
     * 卡密code
     */
    private String kmCode;

    /**
     * 卡密密码
     */
    private String kmPassword;

    /**
     * 卡密链接
     */
    private String kmLink;

    /**
     * 优惠券Id
     */
    private String couponId;

    /**
     * 快递公司名称
     */
    private String expressCompanyName;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * 有效期起始时间，毫秒数，1970.1.1开始的毫秒数
     * ● 商品为微信立减金/支付宝立减金时，为券的有效起始时间，仅开启了配置才有
     */
    private Long beginTime;
}
