package cn.com.duiba.quanyi.center.api.dto.settlement.receive;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 回款关联或取消关联记录
 * @author mybatis generator 
 * @date 2024-12-11
 */
@Data
public class ReceivedPaymentRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17338978956766422L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 回款ID，tb_received_payment.id
     */
    private Long receiveId;

    /**
     * 记录类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedRecordTypeEnum
     */
    private Integer recordType;

    /**
     * 审批状态
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum
     */
    private Integer approvalStatus;

    /**
     * 创建记录时回款状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedStatusEnum
     */
    private Integer fromReceivedStatus;

    /**
     * 关联记录ID
     */
    private Long refRecordId;

    /**
     * 发起人部门ID
     */
    private Long originatorDeptId;

    /**
     * 发起人ssoId
     */
    private Long originatorSsoId;

    /**
     * 发起人钉钉用户ID
     */
    private String originatorUserId;

    /**
     * 自选审批人ssoId
     */
    private Long actionerSsoId;

    /**
     * 自选审批人钉钉用户ID
     */
    private String actionerUserId;
}