package cn.com.duiba.quanyi.center.api.dto.taibao.cq;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.taibao.cq.CqtbOrderStatusEnum;
import lombok.Data;

/**
 * 重庆太保定制-API供货主订单表
 * @author mybatis generator 
 * @date 2025-01-21
 */
@Data
public class CqtbApiOrderDto implements Serializable {
     
    private static final long serialVersionUID = 17374433349023562L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 金额，单位分
     */
    private Long amount;

    /**
     * 微信头像，可选
     */
    private String wxHead;

    /**
     * 微信昵称，可选
     */
    private String wxNickname;

    /**
     * 服务商微信openId
     */
    private String wxOpenId;

    /**
     * 服务商微信appId
     */
    private String wxAppId;

    /**
     * 太保支付单号
     */
    private String payNo;

    /**
     * 太保手机号Md5值
     */
    private String phone;

    /**
     * 太保单号
     */
    private String thirdOrderId;

    /**
     * 订单状态
     * @see CqtbOrderStatusEnum#getCode()
     */
    private Integer orderStatus;

    /**
     * 推送时的data
     * @see CqtbApiOrderNotifyDataDto
     */
    private String notifyData;
}