package cn.com.duiba.quanyi.center.api.remoteservice.mall.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.goods.MallSpuDto;
import cn.com.duiba.quanyi.center.api.enums.mall.MallStatusEnum;
import cn.com.duiba.quanyi.center.api.param.mall.goods.MallSpuSearchParam;
import java.util.List;
import java.util.Set;

/**
 * 商城商品spu
 * @author kjj mybatis generator 
 * @date 2024-05-25
 */
@AdvancedFeignClient
public interface RemoteMallSpuService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商城商品spu集合
     */
    List<MallSpuDto> selectPage(MallSpuSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MallSpuSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城商品spu
     */
    MallSpuDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键
     * @return 商城商品spu
     */
    List<MallSpuDto> selectByIds(Set<Long> ids);

    /**
     * 更新状态
     *
     * @param id        主键
     * @param newStatus 更新后的状态 {@link MallStatusEnum}
     * @param oldStatus 更新前的状态 {@link MallStatusEnum}
     * @return 执行结果
     */
    int updateStatus(Long id, Integer newStatus, Integer oldStatus);
}