package cn.com.duiba.quanyi.center.api.enums.workflow;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/10/21 17:42
 */
@AllArgsConstructor
@Getter
public enum ApprovalStatusEnum {
    NOT_COMMIT(1, "待提交",Boolean.FALSE),
    COMMIT_FAIL(2, "提交失败",Boolean.FALSE),
    RUNNING(3, "审核中",Boolean.TRUE),
    TERMINATED(4, "已撤回",Boolean.TRUE),
    REFUSE(5, "已打回",Boolean.TRUE),
    AGREE(6, "已通过",Boolean.TRUE),
    DELETE(7, "已删除",Boolean.TRUE),
    ;
    
    private final Integer status;
    
    private final String desc;

    /**
     * 是否显示
     */
    private final Boolean show;
    
    private static final Set<Integer> FINAL_STATUS = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(TERMINATED.getStatus(), REFUSE.getStatus(), AGREE.getStatus(), DELETE.getStatus())));
    
    private static final Map<Integer, ApprovalStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ApprovalStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 显示状态
     */
    private static final List<Integer> SHOW_LIST_STATUS = Arrays.stream(values()).filter(ApprovalStatusEnum::getShow).map(ApprovalStatusEnum::getStatus).collect(Collectors.toList());

    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static ApprovalStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
    
    public static boolean isFinalStatus(Integer status) {
        if (status == null) {
            return false;
        }
        return FINAL_STATUS.contains(status);
    }

    /**
     * 获取可以展示的列表
     * @return
     */
    public static List<Integer> getShowListStatus() {
        return SHOW_LIST_STATUS;
    }
}
