package cn.com.duiba.quanyi.center.api.remoteservice.templatesconfig;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.templatesconfig.TemplatesConfigDetailDto;
import cn.com.duiba.quanyi.center.api.param.templatesconfig.TemplatesConfigDetailSearchParam;
import java.util.List;

/**
 * 模版配置详情表
 * @author kjj mybatis generator 
 * @date 2024-11-29
 */
@AdvancedFeignClient
public interface RemoteTemplatesConfigDetailService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 模版配置详情集合
     */
    List<TemplatesConfigDetailDto> selectPage(TemplatesConfigDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(TemplatesConfigDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 模版配置详情
     */
    TemplatesConfigDetailDto selectById(Long id);


    /**
     * 根据配置id查询模版值内容
     * @param templateConfigId
     * @return
     */
    List<TemplatesConfigDetailDto> selectByTemplateConfigId(Long templateConfigId);

    /**
     * 新增
     * @param dto 模版配置详情
     * @return 执行结果
     */
    int insert(TemplatesConfigDetailDto dto);

    /**
     * 更新
     * @param dto 模版配置详情
     * @return 影响行数
     */
    int update(TemplatesConfigDetailDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}