package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum ActivityExtEnum {

    SUPPLY_GOODS_TYPE(1, "商品类型", false),

    SUPPLY_GRANT_TYPE(2, "供给方式", false),

    SUPPLY_LINK_TYPE(3, "链接券形式(,分割)", false),

    SUPPLY_API_JOINT_ID(4, "API对接ID", false),

    ICBC_CUSTOM_ID(5, "工行-客群id(,分割)", false),
    
    SHORT_URL_EFFECTIVE_DAYS(6, "短链有效天数", true),

    ACTIVITY_PAGE_CONFIG(7, "活动页面配置", false),
    ACTIVITY_PRIZE_CONFIG(8, "活动奖项配置", false),
    ACTIVITY_LIMIT_CONFIG(9, "活动限制配置", false),
    ACTIVITY_BACKGROUND_COLOR(12, "活动背景颜色", true),
    ACTIVITY_AUTO_TAKE(16, "活动是否自动领取", true),
    ACTIVITY_HELP_CONFIG(10, "活动助力配置", false),
    ACTIVITY_TEMP_PUSH_CONFIG(11, "模板活动推送配置", false),
    ACTIVITY_TEMP_STANDARD_CONFIG(13, "模板活动达标配置", false),
    ACTIVITY_TEMP_BANK_SYSTEM(14, "模板活动银行体系", false),
    ACTIVITY_TEMP_WHITE_USER(15, "模板活动白名单配置", false),
    ACTIVITY_SUB_EXPRESS(16, "活动订阅物流配置", false),
    ACTIVITY_TEMP_PAY_CONFIG(17, "模板活支付配置", false),
    ACTIVITY_TEMP_ACTIVITY_TAG(18, "模板活动定制tag", false),
    ACTIVITY_TEMP_PAY_STANDARD(19, "模板活动支付达标", false),
    SUPPLY_SHORT_TRANSFER_IS_ORDER_DETAIL(20, "短链中转页-是否是订单详情页面", false),
    SINGLE_SHORT_URL_EFFECTIVE_DAYS(21, "单张券短链有效天数", false),
    CODE_22(22, "是否开启批次不可用告警", false),
    ACTIVITY_TEMP_USER_LIMIT(23, "模板活动用户身份限制", false),
    ACTIVITY_TEMP_CARD_BIN_CONFIG(24, "模板活动卡BIN配置", false),
    ACTIVITY_TEMP_USER_SIGN_UP(25, "模板活动用户报名", false),
    ACTIVITY_TEMP_BLACK_USER(26, "模板活动黑名单配置", false),


    ;

    private final Integer type;

    private final String desc;

    private final boolean canDelete;

    public static boolean getEnumByCanDelete(Integer type) {
        for (ActivityExtEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.isCanDelete();
            }
        }
        return false;
    }

}
