package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.Getter;

/**
 * @Description 活动皮肤类型枚举
 * @Author cuizhoujian
 * @Date 2025-02-12 19:20:20
 */
@Getter
public enum ActivitySkinTypeEnum {
    DIRER_PRIZE_LIST(BizActTypeEnum.TEMPLATE_DIRECT, 1, "多奖品列表展示"),
    DIRER_NOT_SHOW_PRIZE(BizActTypeEnum.TEMPLATE_DIRECT, 2, "不展示奖品直接领取"),

    PROBABILITY_TURNTABLE(BizActTypeEnum.TEMPLATE_PROBABILITY, 1, "大转盘"),
    PROBABILITY_EGG(BizActTypeEnum.TEMPLATE_PROBABILITY, 2, "砸金蛋"),
    PROBABILITY_SQUARE_TURNTABLE(BizActTypeEnum.TEMPLATE_PROBABILITY, 3, "九宫格大转盘"),
    PROBABILITY_EGG_TWIST(BizActTypeEnum.TEMPLATE_PROBABILITY, 4, "扭蛋机"),
    PROBABILITY_NOT_SHOW_PRIZE(BizActTypeEnum.TEMPLATE_PROBABILITY, 5, "直接抽奖不展示奖品"),

    PAY_STANDARD_DEFAULT(BizActTypeEnum.TEMPLATE_PAY_STANDARD, 1, "默认");
    ;


    /**
     * 业务活动类型
     */
    private final BizActTypeEnum bizActTypeEnum;
    /**
     * 皮肤类型
     */
    private final Integer type;
    /**
     * 皮肤描述
     */
    private final String desc;

    ActivitySkinTypeEnum(BizActTypeEnum bizActTypeEnum, Integer type, String desc) {
        this.bizActTypeEnum = bizActTypeEnum;
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据模版活动类型和皮肤类型获取
     * @param bizActType 模版活动类型
     * @param skinType 皮肤类型
     * @return 皮肤类型
     */
    public static ActivitySkinTypeEnum getByBizActTypeAndType(Integer bizActType, Integer skinType) {
        for (ActivitySkinTypeEnum activitySkinTypeEnum : ActivitySkinTypeEnum.values()) {
            if (activitySkinTypeEnum.getBizActTypeEnum().getType().equals(bizActType) && activitySkinTypeEnum.getType().equals(skinType)) {
                return activitySkinTypeEnum;
            }
        }
        return null;
    }
}
