package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 抖音支付券银行卡渠道
 */
@Getter
@AllArgsConstructor
public enum DouYinBankCardChannelEnum {

    CREDIT("CREDIT", "贷记卡"),
    DEBIT("DEBIT", "借记卡"),
    DEBIT_CREDIT("DEBIT,CREDIT", "借记卡或贷记卡"),
    ;

    private final String type;

    private final String desc;

    private static final Map<String, DouYinBankCardChannelEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DouYinBankCardChannelEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static DouYinBankCardChannelEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
