package cn.com.duiba.quanyi.center.api.enums.report;

import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataQueryFieldParam;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/5/21 16:20
 */
@AllArgsConstructor
@Getter
public enum ColumnFormatTypeEnum {
    DEFAULT(1, "不格式化", (bigDataParam) -> {
        return bigDataParam.getFieldName()+" as \""+ bigDataParam.getAliasName() + "\"";
    }),
    DIVER_100_FLOAT(2, "除100保留浮点数2位", (bigDataParam) -> {
        return "round(("+bigDataParam.getFieldName()+"/100::numeric), 2)"+" as \""+bigDataParam.getAliasName()+ "\"";
    }),
    TEXT(3, "文本格式", (bigDataParam) -> {
        return "concat('`',"+bigDataParam.getFieldName()+")"+" as \""+bigDataParam.getAliasName()+ "\"";
    }),
    DATETIME(4, "日期格式", (bigDataParam) -> {
        return "to_char("+bigDataParam.getFieldName()+", 'YYYY-MM-DD HH24:MI:SS')"+" as \""+bigDataParam.getAliasName()+ "\"";
    }),
    STRING_DATETIME(5, "文本日期格式", (bigDataParam) -> {
        return bigDataParam.getFieldName()+" as \""+ bigDataParam.getAliasName() + "\"";
    }),
    ;

    private final Integer type;
    
    private final String desc;

    private DuiBaBigDateParamBuilder builder;

    private static Map<Integer, ColumnFormatTypeEnum> calMap;

    static {
        calMap = Arrays.stream(ColumnFormatTypeEnum.values())
                .collect(Collectors.toMap(ColumnFormatTypeEnum::getType, Function.identity()));
    }

    public static ColumnFormatTypeEnum getFormatType(Integer type) {
        return calMap.get(type);
    }

    @FunctionalInterface
    interface DuiBaBigDateParamBuilder {
        String builder(BigdataQueryFieldParam bigDataParam);
    }

    public String builder(BigdataQueryFieldParam bigDataParam) {
        return builder.builder(bigDataParam);
    }
}
