package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.CommonUserExtDto;

import java.util.List;

/**
 * 通用用户信息表
 * @author kjj mybatis generator 
 * @date 2024-06-03
 */
@AdvancedFeignClient
public interface RemoteCommonUserExtService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 通用用户信息
     */
    CommonUserExtDto selectById(Long id);


    /**
     * 根据用户主键查询
     * @param userId 主键
     * @return 通用用户信息
     */
    CommonUserExtDto selectByUserId(Long userId);

    /**
     * 新增
     * @param dto 通用用户信息
     * @return 执行结果
     */
    Long insert(CommonUserExtDto dto);

    /**
     * 更新
     * @param dto 通用用户信息
     * @return 影响行数
     */
    int update(CommonUserExtDto dto);

    /**
     * 根据用户唯一键+用户类型查询
     * @param thirdOnlyId 用户唯一号
     * @param userType 用户类型
     * @return 通用用户信息
     */
    CommonUserExtDto selectByOnlyIdAndType(String thirdOnlyId, Integer userType);

    /**
     * 根据用户ID 批量查询
     * @param userIds 用户ID
     * @return  list
     */
    List<CommonUserExtDto> selectByUserIds(List<Long> userIds);

    /**
     * 根据手机号查询 返回最新的一条记录
     * @param mobile
     * @param userType
     * @return
     */
    CommonUserExtDto selectByMobileAndType(String mobile, Integer userType);

    /**
     * 根据三方id查询
     * @param thirdOnlyId
     * @return
     */
    List<CommonUserExtDto> selectByOnlyId(String thirdOnlyId);

    /**
     * 根据手机号查询
     * @param mobile
     * @return
     */
    List<CommonUserExtDto> selectByMobile(String mobile);

    /**
     * 根据三方id查询
     * @param thirdIds
     * @return
     */
    List<CommonUserExtDto> selectByThirdIds(List<String> thirdIds);

    /**
     * 根据手机号查询用户ID
     * @param mobileList 手机号
     * @return 用户Id集合
     */
    List<CommonUserExtDto> selectUserIdAndMobileByMobileList(List<String> mobileList);

    /**
     * 根据手机号查询用户ID
     * @param thirdIdList 第三方唯一标识
     * @return 用户Id集合
     */
    List<CommonUserExtDto> selectUserIdAndThirdIdByThirdIdList(List<String> thirdIdList);
}