package cn.com.duiba.quanyi.center.api.remoteservice.insurance.harbin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeBaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.cdtb.InsuranceCdtbEquityDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.harbin.InsuranceHarbinEquityDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceHarbinEquitySearchParam;
import cn.com.duiba.quanyi.center.api.param.insurance.cdtb.InsuranceCdtbEquitySearchParam;

import java.util.List;

/**
 * 哈尔滨保险权益表
 * @author kjj mybatis generator 
 * @date 2025-03-10
 */
@AdvancedFeignClient
public interface RemoteInsuranceHarbinEquityService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 哈尔滨保险权益集合
     */
    List<InsuranceHarbinEquityDto> selectPage(InsuranceHarbinEquitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceHarbinEquitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 哈尔滨保险权益
     */
    InsuranceHarbinEquityDto selectById(Long id);

    /**
     * 新增
     * @param dto 哈尔滨保险权益
     * @return 执行结果
     */
    int insert(InsuranceHarbinEquityDto dto);

    /**
     * 更新
     * @param dto 哈尔滨保险权益
     * @return 影响行数
     */
    int update(InsuranceHarbinEquityDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量插入
     * @param list
     * @return
     */
    int batchInsert(List<InsuranceHarbinEquityDto> list);


    /**
     * 通过保单号查询记录
     * @param policyNos 查询条件
     * @return 保险成都太保权益集合
     */
    List<InsuranceHarbinEquityDto> selectByPolicyNos(List<String> policyNos);

}