package cn.com.duiba.quanyi.center.api.remoteservice.settlement.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementOrderPreviewRecordDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementUniqueMarkDateRangeDto;
import cn.com.duiba.quanyi.center.api.param.settlement.stat.SettlementOrderPreviewRecordSearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 结算方案流水记录表
 * @author kjj mybatis generator 
 * @date 2024-11-28
 */
@AdvancedFeignClient
public interface RemoteSettlementOrderPreviewRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算方案流水记录集合
     */
    List<SettlementOrderPreviewRecordDto> selectPage(SettlementOrderPreviewRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SettlementOrderPreviewRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算方案流水记录
     */
    SettlementOrderPreviewRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 结算方案流水记录
     * @return 执行结果
     */
    int insert(SettlementOrderPreviewRecordDto dto);

    /**
     * 更新
     * @param dto 结算方案流水记录
     * @return 影响行数
     */
    int update(SettlementOrderPreviewRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据任务ID查询最新记录
     * @param taskId 主键
     * @return 结算方案流水记录
     */
    SettlementOrderPreviewRecordDto selectByLastRecordByTaskId(String taskId);

    /**
     * 根据任务ID查询总金额
     * @param taskIdList 主键
     * @return 结算方案流水记录
     */
    Long selectTotalAmountByTaskId(List<String> taskIdList);

    /**
     * 根据任务ID查询去重标识
     * @param taskIdList
     * @param lastId
     * @param pageSize
     * @return
     */
    List<SettlementOrderPreviewRecordDto> selectUniqueMarkByTaskId(List<String> taskIdList, Long lastId, Integer pageSize);

    /**
     * 根据任务ID查询统计时间
     * @param taskIdList
     * @return (max_stat_date, min_stat_date)
     */
    Map<String, Date> selectStatDateByTaskId(List<String> taskIdList);

    /**
     * 更新任务ID
     * @param oldTaskIdList
     * @param newTaskId
     * @return
     */
    int updateTaskId(List<String> oldTaskIdList, String newTaskId);

    /**
     * 根据条件查询，分页，结算订单统计列表查询专用
     * @param param
     * @return
     */
    List<SettlementGoodsDto> selectGroupByDemandGoodsId(SettlementOrderPreviewRecordSearchParam param);

    /**
     * 根据条件查询总行数
     * @param param
     * @return
     */
    Long selectCountGroupByDemandGoodsId(SettlementOrderPreviewRecordSearchParam param);

    /**
     * 查询出账单下载附件
     * @param uniqueMarkList
     * @param taskIdList
     * @return
     */
    List<String> selectPaymentAttachment(List<String> uniqueMarkList, List<String> taskIdList);

    /**
     * 根据条件UniqueMark开始跟结束时间
     * @param uniqueMarkList
     * @param taskIdList
     * @return
     */
    List<SettlementUniqueMarkDateRangeDto> selectStatDateByTaskIdAndUniqueMark(List<String> uniqueMarkList, List<String> taskIdList);
}