package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.Getter;

/**
 * @Description 活动页面配置枚举
 * @Author cuizhoujian
 * @Date 2025-03-19 10:14:49
 */
@Getter
public enum ActivityTaskConfigEnum {
    PAGE_HEADER(1, "页头", ActivityTaskEnum.PAGE_HEADER),
    ACTIVITY_RULE(2, "活动规则", ActivityTaskEnum.ACTIVITY_RULE),
    SIGN_UP_BUTTON(3, "报名按钮", ActivityTaskEnum.SIGN_UP_BUTTON),
    ENTRANCE_PIC(4, "活动入口", ActivityTaskEnum.ENTRANCE_PIC),
    ACTIVITY_CONTENT(5, "活动内容", ActivityTaskEnum.ACTIVITY_CONTENT),
    BACK_GROUND_COLOR(6, "背景色", ActivityTaskEnum.BACK_GROUND_COLOR)
    ;
    private final Integer type;
    private final String desc;
    private final ActivityTaskEnum activityTaskEnum;

    ActivityTaskConfigEnum(Integer type, String desc, ActivityTaskEnum activityTaskEnum) {
        this.type = type;
        this.desc = desc;
        this.activityTaskEnum = activityTaskEnum;
    }
}
