package cn.com.duiba.quanyi.center.api.remoteservice.settlement.holo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloCreateResultDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloStatDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementGoodsDto;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloCreateGoodsParam;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloCreateParam;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloGoodsParam;
import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloPreviewResultDto;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloPreviewGoodsParam;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloPreviewParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * @author lizhi
 * @date 2024/11/26 14:12
 */
@AdvancedFeignClient
public interface RemoteSettlementHoloService {

    /**
     * 分页查询需求商品
     * @param param 查询参数
     * @return 需求商品
     */
    PageResponse<SettlementHoloGoodsDto> selectGoodsPage(SettlementHoloGoodsParam param);

    /**
     * 按期望金额，预生成两个方案
     * @param param 参数
     * @return 任务ID
     */
    String asyncPreview(SettlementHoloPreviewParam param);

    /**
     * 按期望金额，预生成结果
     * @param taskId 任务ID
     * @return 结果
     */
    BaseResultDto<SettlementHoloPreviewResultDto> previewResult(String taskId);

    /**
     * 分页查询方案商品
     * @param param 分页查询参数
     * @return 方案商品列表
     */
    PageResponse<SettlementGoodsDto> previewGoodsPage(SettlementHoloPreviewGoodsParam param);

    /**
     * 异步生成结算单
     * @param param 结算单信息
     */
    void asyncCreate(SettlementHoloCreateParam param);

    /**
     * 创建结果（轮询）
     * @param settlementId 结算单ID
     * @return 结果
     */
    BaseResultDto<SettlementHoloCreateResultDto> createResult(Long settlementId);

    /**
     * 分页查询结算单商品
     * @param param 结算单ID
     * @return 结算单对应的商品列表
     */
    PageResponse<SettlementGoodsDto> createGoodsPage(SettlementHoloCreateGoodsParam param);

    /**
     * 分页查询结算单对应的统计表ID
     * @param param 结算单ID
     * @return 结算单对应的统计表ID
     */
    PageResponse<SettlementHoloStatDto> createStatIdPage(SettlementHoloCreateGoodsParam param);


}
