package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 需求统计表
 * @author mybatis generator 
 * @date 2024-07-18
 */
@Data
public class DemandStatisticDto implements Serializable {
     
    private static final long serialVersionUID = 17212962603422173L;

    /**
     * 唯一标识，每条记录一个唯一值
     */
    private Long id;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 统计日期
     */
    private Date statisticDate;

    /**
     * 累计发放笔数：订单领取笔数，T+1
     */
    private Long totalIssuedCount;

    /**
     * 累计核销笔数：默认展示截止当前，累计核销笔数，T+1
     */
    private Long totalVerifiedCount;

    /**
     * 累计核销净额（不含服务费）
     */
    private Long totalVerifiedNetAmountWithoutServiceFee;

    /**
     * 总应收帐款（含服务费）：默认展示截止当前，累计核销净额*服务费，T+1
     */
    private Long totalReceivablesWithServiceFee;

    /**
     * 已开票金额（含服务费）：默认展示截止当前，已经结算的核销金额（含服务费），T+1；取自结算单；点击进入结算列表
     */
    private Long invoicedAmountWithServiceFee;

    /**
     * 已打款金额（含服务费）：默认展示截止当前，已经打款的核销金额（含服务费），T+1；取自打款明细
     */
    private Long paidAmountWithServiceFee;

    /**
     * 结算金额
     */
    private Long settlementAmount;

    /**
     * 容错金额
     */
    private Long toleranceAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}