package cn.com.duiba.quanyi.center.api.dto.settlement.stat;

import cn.com.duiba.quanyi.center.api.enums.contract.SettlementMethodEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算订单统计-日纬度
 * @author mybatis generator 
 * @date 2024-11-26
 */
@Data
public class SettlementOrderStatDayDto implements Serializable {
     
    private static final long serialVersionUID = 17325899993232412L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 项目商品ID
     */
    private Long projectGoodsId;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 批次号，默认-
     */
    private String stockId;

    /**
     * 活动ID，默认-
     */
    private String thirdActivityId;

    /**
     * 活动名称，默认-
     */
    private String activityName;

    /**
     * 钱包号，默认-
     */
    private String walletNum;

    /**
     * 唯一标记，需求商品ID与批次号，以_分隔；垫资：XX_XX
     */
    private String uniqueMark;

    /**
     * 采购商品类型
     */
    private Integer purchaseSpuType;

    /**
     * 技术商品类型
     */
    private Integer spuType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 日期
     */
    private Date statDate;

    /**
     * 面额
     */
    private Long couponAmount;

    /**
     * 最小结算费率
     */
    private String minSettlementRate;

    /**
     * 最大结算费率
     */
    private String maxSettlementRate;

    /**
     * 最小结算价
     */
    private Long minSettlementPrice;

    /**
     * 最大结算价
     */
    private Long maxSettlementPrice;

    /**
     * 卡单订单数量
     */
    private Long processingOrderNum;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 消耗数-按签收结算
     */
    private Long consumedNumSign;

    /**
     * 优惠金额-按签收结算
     */
    private Long discountAmountSign;

    /**
     * 应收金额-按签收结算
     */
    private Long receivableAmountSign;

    /**
     * 消耗数-按领取结算
     */
    private Long consumedNumSuccess;

    /**
     * 优惠金额-按领取结算
     */
    private Long discountAmountSuccess;

    /**
     * 应收金额-按领取结算
     */
    private Long receivableAmountSuccess;

    /**
     * 消耗数-按核销结算
     */
    private Long consumedNumVerification;

    /**
     * 优惠金额-按核销结算
     */
    private Long discountAmountVerification;

    /**
     * 应收金额-按核销结算
     */
    private Long receivableAmountVerification;

    /**
     * 消耗数-按打款结算
     */
    private Long consumedNumPayment;

    /**
     * 优惠金额-按打款结算
     */
    private Long discountAmountPayment;

    /**
     * 应收金额-按打款结算
     */
    private Long receivableAmountPayment;

    /**
     * 消耗数-按发放结算
     */
    private Long consumedNumGrant;

    /**
     * 优惠金额-按发放结算
     */
    private Long discountAmountGrant;

    /**
     * 应收金额-按发放结算
     */
    private Long receivableAmountGrant;

    /**
     * 消耗数-按首次核销结算
     */
    private Long consumedNumFirstVerification;

    /**
     * 优惠金额-按首次核销结算
     */
    private Long discountAmountFirstVerification;

    /**
     * 应收金额-按首次核销结算
     */
    private Long receivableAmountFirstVerification;

    /**
     * 锁定状态：0-未锁定，1-已锁定
     */
    private Integer lockStatus;

    /**
     * 结算单ID-开票
     */
    private Long settlementId;

    /**
     * 结算方式-开票
     */
    private Integer settlementMethod;

    /**
     * 消耗数-开票
     */
    private Long consumedNum;

    /**
     * 优惠金额-开票
     */
    private Long discountAmount;

    /**
     * 应收金额-开票
     */
    private Long receivableAmount;

    /**
     * 容差金额-开票
     */
    private Long toleranceAmount;

    /**
     * 结算金额
     */
    private Long settlementAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 格式：发票ID_0_金额，发票ID_0_金额
     */
    private String invoiceIds;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 格式：发票ID_回款ID_金额,发票ID_回款ID_金额
     */
    private String receiveIds;

    /**
     * 付款附件
     */
    private String paymentAttachment;

    /**
     * 需求名称
     */
    private String demandName;

    /**
     * 商品规格
     */
    private String skuConf;

    /**
     * 天粒度与汇总粒度计算容差金额
     */
    private Long sumToleranceAmount;

    /**
     * 天粒度与汇总粒度计算容差金额—首次核销
     */
    private Long sumToleranceAmountFirstVerification;
    /**
     * 天粒度与汇总粒度计算容差金额—按发放
     */
    private Long sumToleranceAmountGrant;
    /**
     * 天粒度与汇总粒度计算容差金额-按打款
     */
    private Long sumToleranceAmountPayment;
    /**
     * 天粒度与汇总粒度计算容差金额-按核销
     */
    private Long sumToleranceAmountVerification;
    /**
     * 天粒度与汇总粒度计算容差金额-按领取
     */
    private Long sumToleranceAmountSuccess;
    /**
     * 天粒度与汇总粒度计算容差金额-按签收
     */
    private Long sumToleranceAmountSign;

    /**
     * 更新标识：0-不需要更新，1-需要更新
     */
    private Integer updateStatus = 0;


    public Long getRefundAmount(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case FIRST_VERIFICATION:
                return 0L;
            case GRANT:
                return 0L;
            default:
                return refundAmount;
        }
    }

    public Long getConsumedNum(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return consumedNumVerification;
            case ORDER_SUCCESS:
                return consumedNumSuccess;
            case SIGN:
                return consumedNumSign;
            case PAYMENT:
                return consumedNumPayment;
            case GRANT:
                return consumedNumGrant;
            case FIRST_VERIFICATION:
                return consumedNumFirstVerification;
            default:
                return null;
        }
    }

    public Long getDiscountAmount(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return discountAmountVerification;
            case ORDER_SUCCESS:
                return discountAmountSuccess;
            case SIGN:
                return discountAmountSign;
            case PAYMENT:
                return discountAmountPayment;
            case GRANT:
                return discountAmountGrant;
            case FIRST_VERIFICATION:
                return discountAmountFirstVerification;
            default:
                return null;
        }
    }

    public Long getReceivableAmount(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return receivableAmountVerification;
            case ORDER_SUCCESS:
                return receivableAmountSuccess;
            case SIGN:
                return receivableAmountSign;
            case PAYMENT:
                return receivableAmountPayment;
            case GRANT:
                return receivableAmountGrant;
            case FIRST_VERIFICATION:
                return receivableAmountFirstVerification;
            default:
                return null;
        }
    }


    public Long getToleranceAmount(Integer settlementMethod) {
        SettlementMethodEnum methodEnum = SettlementMethodEnum.getByType(settlementMethod);
        if (methodEnum == null) {
            return null;
        }
        switch (methodEnum) {
            case VERIFICATION:
                return sumToleranceAmountVerification;
            case ORDER_SUCCESS:
                return sumToleranceAmountSuccess;
            case SIGN:
                return sumToleranceAmountSign;
            case PAYMENT:
                return sumToleranceAmountPayment;
            case GRANT:
                return sumToleranceAmountGrant;
            case FIRST_VERIFICATION:
                return sumToleranceAmountFirstVerification;
            default:
                return null;
        }
    }
}