package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxMchExternalRefDto;
import cn.com.duiba.quanyi.center.api.param.coupon.WxMchExternalRefSaveParam;

import java.util.List;
import java.util.Set;

/**
 * 微信商户关联外部商户号
 * @author kjj mybatis generator 
 * @date 2025-01-06
 */
@AdvancedFeignClient
public interface RemoteWxMchExternalRefService {

    /**
     * 根据商户号查询
     * @param mchId 商户号
     * @return 微信商户关联外部商户号
     */
    List<WxMchExternalRefDto> selectByMchId(String mchId);

    /**
     * 保存
     * @param param 参数
     * @return 是否成功
     */
    boolean save(WxMchExternalRefSaveParam param);
}