package cn.com.duiba.quanyi.center.api.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

import java.util.Objects;

/**
 * @author zzy
 * @create 2023/10/17 20:01
 **/
@ToString
@Getter
@AllArgsConstructor
public enum UserTypeEnum {
    MP_UNIONID(1, "小程序unionId"),
    H5_COUPON_CODE(2, "H5匿名券码用户"),
    OA_OPENID(3, "公众号静默授权openId"),
    CCB_ZJ_HSQ(4, "浙江建行恵省钱对接"),
    CCB_DINGTALK(5, "建行钉钉联合营销钉钉用户"),
    MP_COUPON_CODE(6, "小程序匿名券码用户"),
    OA_COUPON_CODE(7, "公众号匿名券码用户"),
    ICBC_JX(8, "江西工行用户"),
    ALIPAY_USER_ID(9, "支付宝userId"),
    TOURIST_USER(10, "游客"),
    ICBC_GD(11, "广东工行用户"),
    INSURANCE_CUSTOMER(12, "保司权益领取用户"),
    OA_UNION_ID(13, "公众号手动授权unionId"),
    ICBC_SHAANXI(14, "陕西工行用户"),
    ICBC_XJ(15, "新疆工行用户"),
    JS_EMS_SNS_SHOP(16, "江苏邮储智慧校园"),
    HNAG_ZHOU_BANK(17, "杭州银行商城登录用户"),
    MINSHENG_BANK(18, "民生银行用户"),
    ICBC_XJ_NO_CHECK_CUSTOMID(19, "新疆工行不校验customId用户"),
    ABC_HN_CS(20, "农行湖南长沙用户"),
    MINSHENG_EXCHANGE(21, "民生银行兑换认证用户"),
    API_USER(22, "API供给用户"),
    ABC_HN_HH(24, "农行湖南怀化分行"),
    ABC_HN_ZZ(25, "农行湖南株洲分行"),
    ABC_HN_LD(26, "农行湖南娄底分行"),
    ABC_HN_CZ(27, "农行湖南郴州分行"),
    INSURANCE_LAND(23, "保司大地财险权益用户"),
    ABC_USER(28, "农行掌银用户"),
    ICBC_SHANXI_USER(29, "山西工行APP用户"),
    WHITE_CUSTOMER_MANAGER(30, "白名单录入管理用户"),
    PSBC_MALL_USER(31, "邮储宠物商城用户"),
    ABC_HN(32, "农行湖南分行"),
    CGB_APP(33, "广发银行APP用户"),
    MINSHENG_AUDIOVISUAL(34, "民生视听专区用户"),
    CGB_APP_NEW(36, "广发银行APP用户"),
    ICBC_XJ_NONE_STAFF(37, "非新疆工行用户"),
    BOC_ACTIVITY(35, "中行用户（网银客户号）"),
    BOC_CIF_ACTIVITY(39, "中行用户（核心客户号）"),
    BOC_HBSX(40, "中行-湖北三峡"),
    BOC_ZJ(41, "中行-浙江分行"),
    INSURANCE_HARBIN(42, "保司哈尔滨人保权益用户"),
    ;
    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据type值解析
     *
     * @param type
     * @return
     */
    public static UserTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (UserTypeEnum typeEnum : values()) {
            if (Objects.equals(type, typeEnum.type)) {
                return typeEnum;
            }
        }
        return null;
    }

}
