package cn.com.duiba.quanyi.center.api.remoteservice.wx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.wx.WxPayMchRelatedDto;

import java.util.List;
import java.util.Map;

/**
 * 微信支付商户映射表
 * @author kjj mybatis generator 
 * @date 2024-11-08
 */
@AdvancedFeignClient
public interface RemoteWxPayMchRelatedService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信支付商户映射
     */
    WxPayMchRelatedDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信支付商户映射
     * @return 执行结果
     */
    int insert(WxPayMchRelatedDto dto);

    /**
     * 更新
     * @param dto 微信支付商户映射
     * @return 影响行数
     */
    int update(WxPayMchRelatedDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 获取商户编码和商户id的映射关系
     *
     * @param mchCode 调用api的商户编码
     * @param mchCodeList 需要转换的商户编码列表
     * @return 商户编码和商户id的映射关系
     */
    Map<String, String> getAndSyncMchCode2MchIdMap(String mchCode, List<String> mchCodeList) throws BizException;
}