package cn.com.duiba.quanyi.center.api.dto.invoice;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 发票
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
public class InvoiceDto implements Serializable {
     
    private static final long serialVersionUID = 17332088287119365L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 开票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 申请人ID
     */
    private Long createOperatorId;

    /**
     * 发票金额
     */
    private Long invoiceAmount;

    /**
     * 发票抬头Id
     */
    private Long invoiceTitleId;

    /**
     * 开票类型
     */
    private Integer invoiceType;

    /**
     * 税收编码Id
     */
    private Long taxCodeId;

    /**
     * 开票摘要
     */
    private String invoiceSummary;

    /**
     * 发票状态：1-待开票，2-已开票，3-红充审批中 4-已红充，99-已移除
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.InvoiceStatusEnum
     */
    private Integer invoiceStatus;

    /**
     * 发票号
     */
    private String invoiceNum;

    /**
     * xml文件地址
     */
    private String xmlUrl;

    /**
     * ofd文件地址
     */
    private String ofdUrl;

    /**
     * pdf文件地址
     */
    private String pdfUrl;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 开票时间
     */
    private Date invoiceIssueTime;

    /**
     * 开票财务ssoId
     */
    private Long financialSsoId;

    /**
     * 开票财务姓名
     */
    private String financialSsoName;

    /**
     * 红冲审批状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer redOffsetApprovalStatus;

    /**
     * 客户ID
     */
    private Long partnerId;

    /**
     * 发票备注
     */
    private String invoiceRemark;

    /**
     * 发票回款状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.InvoiceReceivedStatusEnum
     */
    private Integer invoiceReceivedStatus;
}