package cn.com.duiba.quanyi.center.api.dto.project;

import cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目
 * @author mybatis generator 
 * @date 2024-10-21
 */
@Data
public class ProjectDto implements Serializable {
     
    private static final long serialVersionUID = 17294988941151590L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 关联客户ID
     */
    private Long partnerId;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 商务负责人姓名
     */
    private String commerceManagerName;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 运营负责人姓名
     */
    private String operationsManagerName;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 审核状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer approvalStatus;

    /**
     * 项目交付形式
     */
    private String deliveryMethod;

    /**
     * 交付风险评估
     */
    private String deliveryRiskAssessment;

    /**
     * 结算风险评估
     */
    private String settlementRiskAssessment;


    /**
     * 所属业务
     * @see BelongingBusinessTypeEnum#getType()
     */
    private Integer belongingBusiness;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 项目编号
     */
    private String projectNo;
}