package cn.com.duiba.quanyi.center.api.dto.icbc.sx;

import lombok.Data;

import java.io.Serializable;

/**
 * 山西工行权益推送记录
 * @author mybatis generator 
 * @date 2024-01-30
 */
@Data
public class IcbcSxWriteOffPushRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17066086635419641L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一键 md5(activityNo+ticketNo+usedTime+tradType)
     */
    private String uniqueKey;

    /**
     * 活动id（一个活动唯一，联系活动登记人）
     */
    private String activityNo;

    /**
     * 微信批次id
     */
    private String batchNo;

    /**
     * 1-支付宝 2-微信
     */
    private Integer writeOffChannel;
    /**
     * 供应商编号
     */
    private String supplierNo;

    /**
     * 优惠券id
     */
    private String ticketNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 银行流水号
     */
    private String bankSerialNo;

    /**
     * 订单金额
     */
    private String orderAmount;

    /**
     * 优惠金额
     */
    private String preferAmount;

    /**
     * 券使用时间
     */
    private String usedTime;

    /**
     * 交易类型
     */
    private String tradType;

    /**
     * 1-推送中 2-推送成功 3-推送失败
     * {@link cn.com.duiba.quanyi.center.api.enums.icbc.sx.IcbcSxWriteOffPushStatusEnum}
     */
    private Integer pushStatus;

    /**
     * 推送返回code
     */
    private Integer pushReturnCode;

    /**
     * 推送返回msg
     */
    private String pushReturnMsg;

    /**
     * 上传记录id
     */
    private Long taskId;

    /**
     * 推送类型
     * @see cn.com.duiba.quanyi.center.api.enums.bill.BillPushTypeEnum
     */
    private Integer pushType;

}