package cn.com.duiba.quanyi.center.api.param.qystatistic;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝活动金额统计
 * @author mybatis generator 
 * @date 2024-09-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AlipayActivityAmountStatisticSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17262100739718104L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 支付宝活动名称
     */
    private String alipayActName;

    /**
     * 支付宝活动后台类型，1-银行卡支付立减;2-通用渠道红包;3-首绑有礼;4-多刷有礼
     */
    private Integer alipayActType;

    /**
     * 同步时间节点
     */
    private Date gmtSync;

    /**
     * 同步实际完成时间点
     */
    private Date gmtFinish;

    /**
     * 同步状态 0-未同步 1-同步成功 2-同步失败
     */
    private Integer syncStatus;

    /**
     * 不活动总预算金额，单位分
     */
    private Long totalBudgetAmount;

    /**
     * 活动预算剩余金额，单位分
     */
    private Long budgetRemainingAmount;

    /**
     * 领取优惠金额，单位分
     */
    private Long receiveDiscountAmount;

    /**
     * 核销优惠金额，单位分
     */
    private Long cancellationAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 触发次数
     */
    private Integer syncNum;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;
}