package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityLogDto;

import java.util.List;

/**
 * 活动流水表
 * @author cuizhoujian
 * @date 2025-01-24
 */
@AdvancedFeignClient
public interface RemoteActivityLogService {
    /**
     * 根据用户id和活动id查询奖品信息
     * @param userId 用户id
     * @param activityId 活动id
     * @return 活动流水
     */
    List<ActivityLogDto> selectPrizeInfoByUserIdAndActivityId(Long userId, Long activityId);

    /**
     * 新增
     * @param dto 活动流水
     * @return 影响的记录行数
     */
    int insert(ActivityLogDto dto);
}