package cn.com.duiba.quanyi.center.api.dto.invoice;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 历史开票
 * @author mybatis generator 
 * @date 2025-01-09
 */
@Data
public class InvoiceHistoryDto implements Serializable {
     
    private static final long serialVersionUID = 17364024891149432L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 归属项目ID
     */
    private Long projectId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 对接人ID
     */
    private Long contactsId;

    /**
     * 发票号
     */
    private String invoiceNum;

    /**
     * 发票抬头
     */
    private String invoiceTitle;

    /**
     * 开票时间
     */
    private Date invoiceIssueTime;

    /**
     * 已开票金额（单位分）
     */
    private Long invoicedAmount;

    /**
     * 已回款金额（单位分）
     */
    private Long receivedAmount;
}