package cn.com.duiba.quanyi.center.api.dto.qy.coupon;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 支付宝立减金自动加款任务表
 * @author mybatis generator 
 * @date 2024-09-02
 */
@Data
public class AlipayActivityAutoAddMoneyTaskDto implements Serializable {
     
    private static final long serialVersionUID = 17252594182754637L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 商户号
     */
    private String mchCode;

    /**
     * 加款任务金额
     */
    private Long taskAmount;

    /**
     * 任务状态 0-初始化 1-加款中 2-加款成功 3-加款失败 4-加款超时
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AutoAddMoneyTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 加款失败原因
     */
    private String errorMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTypeEnum
     */
    private Integer activityType;

    /**
     * 每日发放上限
     */
    private Long dayAmountLimit;

    /**
     * 每日发放上限类型 1-金额 2-数量
     */
    private Long dayAmountLimitType;

    /**
     * 加款前金额
     */
    private Long originAmount;

    /**
     * 1-定时任务 2-库存扣减
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityAutoAddMoneyTypeEnum
     */
    private Integer addType;

    /**
     * 加款前剩余金额
     */
    private Long originSurplusAmount;

    /**
     * 上传任务id
     */
    private Long uploadTaskId;
}