package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.Getter;

/**
 * @Description 白名单客户号类型枚举
 * @Author cuizhoujian
 * @Date 2025-01-17 15:01:26
 */
@Getter
public enum ClientNumberTypeEnum {
    ABC_CLIENT_NUMBER(1, 1, "农行客户号"),
    BOC_BANK_CLIENT_NUMBER(2, 3, "中行网银客户号"),
    BOC_CORE_CLIENT_NUMBER(3, 4, "中行核心客户号"),
    USER_ID_NUMBER(4, 5, "用户ID类型");

    /**
     * 客户号类型
     */
    private Integer type;
    /**
     * 白名单中奖类型
     * {@link TemplateWhiteStandEnum#getType()}
     */
    private Integer limitType;

    private String desc;

    ClientNumberTypeEnum(Integer type, Integer limitType, String desc) {
        this.type = type;
        this.limitType = limitType;
        this.desc = desc;
    }

    public static ClientNumberTypeEnum getByLimitType (Integer limitType) {
        for (ClientNumberTypeEnum clientNumberTypeEnum : ClientNumberTypeEnum.values()) {
            if (clientNumberTypeEnum.getLimitType().equals(limitType)) {
                return clientNumberTypeEnum;
            }
        }
        if (TemplateWhiteStandEnum.PHONE_STANDARD.getType().equals(limitType)) {
            return ClientNumberTypeEnum.ABC_CLIENT_NUMBER;
        }
        return null;
    }
}
