package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 微信立减金资金流水
 * @author mybatis generator 
 * @date 2025-01-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxCouponFundFlowSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17370115839346394L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 微信批次id
     */
    private String stockId;

    /**
     * 记账日期 yyyy-mm-dd
     */
    private LocalDate curDate;

    /**
     * 收支类型 1-支出 2-收入
     */
    private Integer changeType;

    /**
     * 收支金额 分
     */
    private Long changeAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}