package cn.com.duiba.quanyi.center.api.param.settlement.task;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 结算单统计数据处理任务表
 * @author mybatis generator 
 * @date 2024-11-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SettlementStatTaskSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17329512198845553L;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 发票ID
     */
    private Long invoiceId;

    /**
     * 本次总金额
     */
    private Long totalAmount;

    /**
     * 已处理金额
     */
    private Long dealAmount;

    /**
     * 任务类型：1-开票，2-发票红冲，3-回款，4-回款退回
     */
    private Integer taskType;

    /**
     * 任务状态
     */
    private Integer taskStatus;

    /**
     * 失败原因
     */
    private String errMsg;
}