package cn.com.duiba.quanyi.center.api.remoteservice.contract;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.contract.ContractDto;
import cn.com.duiba.quanyi.center.api.dto.partner.PartnerDto;
import cn.com.duiba.quanyi.center.api.param.ContractPageQueryParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 合同表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteContractService {
    /**
     * 查询合同所属的客户
     *
     * @param contractId
     * @return
     */
    PartnerDto findPartnerByContractId(Long contractId);

    /**
     * 查询合同所属的客户
     *
     * @param contractIdList
     * @return
     */
    Map<Long, PartnerDto> findPartnerByContractIdList(Set<Long> contractIdList);


    /**
     * 根据合同编号、客户id查询
     *
     * @param contractCode 合同编号
     * @param partnerId 客户id
     * @return 返回实体信息
     */
    ContractDto findByContractCodeWithPartnerId(String contractCode, Long partnerId);

    /**
     * 根据合同编号查询
     * @param contractCode 合同编号
     * @return 返回实体信息
     */
    ContractDto findByContractCode(String contractCode);

    /**
     * 分页查询
     *
     * @param contractPageQueryParam
     * @return
     */
    List<ContractDto> findPageByParam(ContractPageQueryParam contractPageQueryParam);


    /**
     * 统计
     *
     * @param contractPageQueryParam
     * @return
     */
    Integer countByParam(ContractPageQueryParam contractPageQueryParam);

    /**
     * 查询客户id下所有的合同
     *
     * @param partnerId
     * @return
     */
    List<ContractDto> findByPartnerId(Long partnerId);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    Long insert(ContractDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    int update(ContractDto dto);

    /**
     * 根据id查询
     *
     * @param contractId
     * @return
     */
    ContractDto findById(Long contractId);

    /**
     * 根据id list查询
     *
     * @param list
     * @return
     */
    Map<Long, ContractDto> findByIdList(Set<Long> list);

    /**
     * 根据创建人id批量修改信息为当前登录人
     * @param param 创建人id
     * @return 返回受影响的行数
     */
    Integer batchUpdateOperator(ContractPageQueryParam param);

    /**
     * 根据条件查询对应的合同信息
     * @param param 条件参数
     * @return 返回结果信息
     */
    List<ContractDto> list(ContractPageQueryParam param);

    /**
     * 查询(不分页)
     * @param contractPageQueryParam 参数
     * @return 结果
     */
    List<ContractDto> selectNoPage(ContractPageQueryParam contractPageQueryParam);


    /**
     * 根据项目id查询合同信息
     * @param projectIds 项目id集合
     * @return 结果信息
     */
    List<ContractDto> selectByProjectIds(List<Long> projectIds);

    /**
     * 新增或修改合同
     *
     * @param contractDto 合同信息
     * @return 结果
     */
    Long saveOrUpdateContract(ContractDto contractDto);

}