package cn.com.duiba.quanyi.center.api.remoteservice.demand;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandGoodsDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandGoodsSkuSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 需求商品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteDemandGoodsService {

    /**
     * 根据需求商品表id查询需求商品详情
     *
     * @param id 需求商品表id
     * @return 需求商品详情
     */
    DemandGoodsDto getDemandGoodsInfo(Long id);

    /**
     * 根据采购单id查询需求商品详情
     *
     * @param demandId 采购单id
     * @return 需求商品详情
     */
    List<DemandGoodsDto> getDemandGoodsListByDemandId(Long demandId);

    /**
     * 根据采购单id查询需求商品详情
     *
     * @param demandId 采购单id
     * @param purchaseStatusList 采购状态
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PurchaseStatusEnum
     * @param goodsStatus 商品状态
     * @return 需求商品详情
     */
    List<DemandGoodsDto> getListByDemandIdPurchaseStatus(Long demandId, List<Integer> purchaseStatusList, Integer goodsStatus);

    /**
     * 根据ID集合查找
     *
     * @param demandGoodIdList ID集合
     * @return 需求商品详情
     */
    List<DemandGoodsDto> getByIdList(List<Long> demandGoodIdList);

    /**
     * 根据需求商品表id更新需求商品
     *
     * @param demandGoodsDto 需求商品信息
     * @return 操作条数
     */
    int updateDemandGoodsById(DemandGoodsDto demandGoodsDto);

    /**
     * 新增需求商品信息
     *
     * @param demandGoodsDto 需求商品信息
     * @return 操作条数
     */
    Long insertDemandGoods(DemandGoodsDto demandGoodsDto);

    /**
     * 根据需求商品单id删除需求商品
     *
     * @param id 需求商品单id
     * @return 操作条数
     */
    int deleteDemandGoods(Long id);

    /**
     * 根据项目商品id查询需求商品信息
     *
     * @param projectGoodsId 项目商品id
     * @return 需求商品信息
     */
    List<DemandGoodsDto> selectByProjectGoodsId(Long projectGoodsId);

    /**
     * 查询需求商品涉及的需求ID
     * @param ids 主键
     * @return 需求ID
     */
    List<Long> selectDemandIdListByIds(Set<Long> ids);

    /**
     * 更新备注
     * @param id 主键ID
     * @param remark 备注
     * @return
     */
    int updateRemarkById(Long id, String remark);

    /**
     * 根据需求ID查询需求商品ID
     * @param demandIds 需求ID集合
     * @return 需求商品ID
     */
    List<Long> selectIdsByDemandIds(List<Long> demandIds);

    /**
     * 更新需求商品退款结算截止日
     * @param ids 需求商品id集合
     * @param settlementDeadlineDays 退款结算截止日
     * @return 影响行数
     */
    int updateSettlementDeadlineDaysByIds(List<Long> ids, Integer settlementDeadlineDays);
    /**
     * 根据商品skuId需求商品
     * @param param 查询参数
     * @return 需求商品信息
     */
    List<DemandGoodsDto> getListBySku(DemandGoodsSkuSearchParam param);

    /**
     * 根据项目商品id列表查询未删除需求商品信息
     * @param projectGoodsIds
     * @return
     */
    List<DemandGoodsDto> selectByProjectGoodsIds(Set<Long> projectGoodsIds);

    /**
     * 根据需求id和商品id查询需求商品
     * @param demandId 需求id
     * @param id 需求商品id
     * @return 需求商品列表
     */
    List<DemandGoodsDto> selectByDemandIdAndId(Long demandId, Long id);
}